const { db } = require('./config/db');

async function checkDatabaseHealth() {
  try {
    console.log('🔍 Checking database connection...');
    const connection = await db.getConnection();
    console.log('✅ Database connection successful');
    connection.release();
    
    // Test a simple query
    const [result] = await db.query('SELECT 1 as test');
    console.log('✅ Database query test successful:', result);
    
    return true;
  } catch (err) {
    console.error('❌ Database health check failed:', err.message);
    return false;
  }
}

async function monitorConnection() {
  console.log('🚀 Starting database connection monitor...');
  
  // Initial check
  await checkDatabaseHealth();
  
  // Monitor every 30 seconds
  setInterval(async () => {
    const isHealthy = await checkDatabaseHealth();
    if (!isHealthy) {
      console.log('⚠️  Database connection issues detected');
    }
  }, 30000);
}

// Run if called directly
if (require.main === module) {
  monitorConnection();
}

module.exports = { checkDatabaseHealth, monitorConnection };
